/* ============ */
/* pkrchisq.c	*/
/* ============ */
#include <defcodes.h>
#include <pokrdefs.h>

/* ------------------- */
/* FUNCTION PROTOTYPES */
/* ------------------- */
# undef F
# if defined(__STDC__) || defined(__PROTO__)
#	define  F( P )  P
# else
#	define  F( P )  ()
# endif

/* INDENT OFF */
extern	void	CalcPokerChiSq F((struct PokerDataStru *));
static	int	DealNewHand F((struct PokerDataStru *));

# undef F
/* INDENT ON */

long	NDiffCtrs[MAX_CARDS];

#define	DELETED	-1
/* ==================================================================== */
/* CalcPokerChiSq - Calculates Chi-Square Statistic for Poker Test	*/
/* ==================================================================== */
void
CalcPokerChiSq(POKER_DATA_STRU * PokerData)
{
    /* ---------------------------------------------------------------- */
    /* Clear NDiff counters 						*/
    /* Calculate Poker-Probabilities for this CardsPerHand & DataSize	*/
    /*									*/
    /* for j = 1 to NumHands						*/
    /*	  1. Deal a hand, get NDiff					*/
    /*	  2. Increment corresponding NDiff counter			*/
    /*									*/
    /* Calculate Chi-Square Statistic, Store at PokerData->PokerChiSq	*/
    /*									*/
    /* Return								*/
    /* ---------------------------------------------------------------- */

    int     j;
    long    k;

    memset(NDiffCtrs, 0, sizeof(NDiffCtrs));

    for (k = 1; k <= PokerData->NumHands; ++k)
    {
	int	NumDiff;
	NumDiff = DealNewHand(PokerData);
	++NDiffCtrs[NumDiff-1];
    }
    /* --------------------------- */
    /* Lump Categories as Required */
    /* --------------------------- */
    for (j = 0; j < PokerData->NotEnough; ++j)
    {
	NDiffCtrs[j+1] += NDiffCtrs[j];
    }

    /* ------------------------------ */
    /* Calculate Chi-Square Statistic */
    /* ------------------------------ */
    PokerData->PokerChiSq = 0;

    for (j = PokerData->NotEnough; j < PokerData->CardsPerHand; ++j)
    {
	if (NDiffCtrs[j])
	{
	    PokerData->PokerChiSq +=
		SQR((double)NDiffCtrs[j]) / PokerData->CellExpect[j];
	}
	P(printf("\tPokerChiSq = %.15e\n", PokerData->PokerChiSq));
    }

    PokerData->PokerChiSq -= PokerData->NumHands;
    PokerData->CallStatusOK = TRUE;
}
/* ==================================================================== */
/* DealNewHand - Deals a Hand of Size CardsPerHand and Returns NumDiff	*/
/* ==================================================================== */
static	int
DealNewHand(POKER_DATA_STRU  *PokerData)
{
    int     j, k, NumDiff;
    int     ThisHand[MAX_CARDS];

    /* ------------------------------------------------ */
    /* Deal This Hand of PokerData->CardsPerHand cards.	*/
    /* Count Number of Different Cards in the Hand.	*/
    /* ------------------------------------------------ */
    for (j = 0; j < PokerData->CardsPerHand; ++j)
    {
	ThisHand[j] = PokerData->RandFun() % PokerData->DataSize;
    }

    /* -------------------------------------- */
    /* Accumulating Number Variates Generated */
    /* -------------------------------------- */
    PokerData->TotNumGen += PokerData->CardsPerHand;

    NumDiff = PokerData->CardsPerHand;

    /* ----------------------------- */
    /* Determine Number Different by */
    /* Rules of Knuth, Vol. 2. p. 62 */
    /* ----------------------------- */
    for (j = 0; j < PokerData->CardsPerHand-1; ++j)
    {
	if (ThisHand[j] == DELETED)
	{
	    continue;
	}
	for(k = j + 1; k < PokerData->CardsPerHand; ++k)
	{
	    if (ThisHand[k] == ThisHand[j])
	    {
		ThisHand[k] = DELETED;
		--NumDiff;
	    }
	}
    }

    return (NumDiff);
}
